SET TERM ^ ;



CREATE OR ALTER TRIGGER DADOS_PROCESSOS_CAPTURA FOR DADOS
ACTIVE AFTER INSERT OR UPDATE POSITION 80
AS
DECLARE VARIABLE COD_PROC_CAPTURA DOM_CODIGO;
BEGIN
  /* Verifica se existe processo na PROCESSOS_CAPTURA */
  IF ((NEW.PROCESSO_CNJ IS DISTINCT FROM OLD.PROCESSO_CNJ) AND
      (NEW.PROCESSO_CNJ IS NOT NULL)) THEN
  BEGIN

    SELECT FIRST 1 PROCESSOS_CAPTURA.CODIGO
    FROM PROCESSOS_CAPTURA
    WHERE PROCESSOS_CAPTURA.PROCESSO = NEW.PROCESSO_CNJ
    INTO :COD_PROC_CAPTURA;

    IF (:COD_PROC_CAPTURA IS NOT NULL) THEN
    BEGIN
      UPDATE PROCESSOS_CAPTURA
      SET PROCESSOS_CAPTURA.COD_DADOS = NEW.CODIGO
      WHERE PROCESSOS_CAPTURA.CODIGO = :COD_PROC_CAPTURA;
    END
  END
END
^

SET TERM ; ^