/******************************************************************************/
/****              Generated by IBExpert 26/05/2022 08:28:55               ****/
/******************************************************************************/

/******************************************************************************/
/****     Following SET SQL DIALECT is just for the Database Comparer      ****/
/******************************************************************************/


/******************************************************************************/
/****                                Tables                                ****/
/******************************************************************************/


CREATE GENERATOR GEN_PROCESSOS_CAPTURA_ID;

CREATE TABLE PROCESSOS_CAPTURA (
    CODIGO                DOM_CODIGO NOT NULL /* DOM_CODIGO = INTEGER */,
    COD_DADOS             DOM_CODIGO /* DOM_CODIGO = INTEGER */,
    PROCESSO              DOM_TEXTO_025 /* DOM_TEXTO_025 = VARCHAR(25) */,
    INCIDENTE             DOM_CODIGO /* DOM_CODIGO = INTEGER */,
    COD_INTERCOMUNICACAO  DOM_CODIGO /* DOM_CODIGO = INTEGER */,
    ID                    DOM_TEXTO_050 /* DOM_TEXTO_050 = VARCHAR(50) */,
    STATUS                DOM_LOGICO /* DOM_LOGICO = SMALLINT DEFAULT 0 */,
    DATA_INC              DOM_DATA_HORA /* DOM_DATA_HORA = DATE */,
    COD_USUARIO           DOM_CODIGO /* DOM_CODIGO = INTEGER */,
    STATUS_OBS            DOM_TEXTO_250 /* DOM_TEXTO_250 = VARCHAR(250) */
);




/******************************************************************************/
/****                             Primary keys                             ****/
/******************************************************************************/

ALTER TABLE PROCESSOS_CAPTURA ADD CONSTRAINT PK_PROCESSOS_CAPTURA PRIMARY KEY (CODIGO);


/******************************************************************************/
/****                             Foreign keys                             ****/
/******************************************************************************/

ALTER TABLE PROCESSOS_CAPTURA ADD CONSTRAINT FK_PROCESSOS_CAPTURA_1 FOREIGN KEY (COD_INTERCOMUNICACAO) REFERENCES INTERCOMUNICACOES (CODIGO);
ALTER TABLE PROCESSOS_CAPTURA ADD CONSTRAINT FK_PROCESSOS_CAPTURA_2 FOREIGN KEY (COD_DADOS) REFERENCES DADOS (CODIGO);


/******************************************************************************/
/****                               Triggers                               ****/
/******************************************************************************/



SET TERM ^ ;



/******************************************************************************/
/****                         Triggers for tables                          ****/
/******************************************************************************/



/* Trigger: PROCESSOS_CAPTURA_BI */
CREATE OR ALTER TRIGGER PROCESSOS_CAPTURA_BI FOR PROCESSOS_CAPTURA
ACTIVE BEFORE INSERT POSITION 0
AS
begin
  if (new.codigo is null) then
    new.codigo = gen_id(GEN_PROCESSOS_CAPTURA_ID,1);
end
^


/* Trigger: PROCESSOS_CAPTURA_DATA_INC */
CREATE OR ALTER TRIGGER PROCESSOS_CAPTURA_DATA_INC FOR PROCESSOS_CAPTURA
ACTIVE BEFORE INSERT POSITION 1
AS
begin
  new.DATA_INC = current_timestamp;
end
^


/* Trigger: PROCESSOS_CAPTURA_USUARIO */
CREATE OR ALTER TRIGGER PROCESSOS_CAPTURA_USUARIO FOR PROCESSOS_CAPTURA
ACTIVE BEFORE INSERT POSITION 2
AS
DECLARE VARIABLE I_TEMP INTEGER;
begin
   SELECT COD_USUARIO 
    FROM FUNCAO_COD_USUARIO 
    INTO :I_TEMP;
    NEW.COD_USUARIO = :I_TEMP;
end
^

SET TERM ; ^



/******************************************************************************/
/****                         Fields descriptions                          ****/
/******************************************************************************/

COMMENT ON COLUMN PROCESSOS_CAPTURA.INCIDENTE IS 
'Nulo ou 0: Não; 1: Sim';

COMMENT ON COLUMN PROCESSOS_CAPTURA.ID IS 
'Id da Central Mineradora';

COMMENT ON COLUMN PROCESSOS_CAPTURA.STATUS IS 
'Nulo ou 0: Pendente; 1: Processando; 2: Processado; 3: Não encontrado';