/******************************************************************************/
/****              Generated by IBExpert 18/08/2022 08:01:29               ****/
/******************************************************************************/

/******************************************************************************/
/****     Following SET SQL DIALECT is just for the Database Comparer      ****/
/******************************************************************************/


/******************************************************************************/
/****                                Tables                                ****/
/******************************************************************************/


CREATE GENERATOR GEN_PROCESSOS_MINERAR_ID;

CREATE TABLE PROCESSOS_MINERAR (
    CODIGO                     DOM_CODIGO NOT NULL /* DOM_CODIGO = INTEGER */,
    COD_PROCESSO_MINERAR_LOTE  DOM_CODIGO /* DOM_CODIGO = INTEGER */,
    TIPO                       DOM_TEXTO_250 /* DOM_TEXTO_250 = VARCHAR(250) */,
    COD_DADOS                  DOM_CODIGO /* DOM_CODIGO = INTEGER */,
    PROCESSO                   DOM_TEXTO_050 /* DOM_TEXTO_050 = VARCHAR(50) */,
    COD_INTERCOMUNICACAO       DOM_CODIGO /* DOM_CODIGO = INTEGER */,
    ID                         DOM_TEXTO_050 /* DOM_TEXTO_050 = VARCHAR(50) */,
    COD_CENTRAL_MINERADORA     DOM_CODIGO /* DOM_CODIGO = INTEGER */,
    STATUS                     DOM_CODIGO DEFAULT 0 /* DOM_CODIGO = INTEGER */,
    OBS                        DOM_TEXTO_250 /* DOM_TEXTO_250 = VARCHAR(250) */,
    DATA_INCLUSAO              DOM_DATA_HORA /* DOM_DATA_HORA = DATE */,
    DATA_ENVIO                 DOM_DATA_HORA /* DOM_DATA_HORA = DATE */,
    DATA_RETORNO               DOM_DATA_HORA /* DOM_DATA_HORA = DATE */,
    COD_USUARIO                INTEGER,
    DATA_INC                   DOM_DATA_HORA /* DOM_DATA_HORA = DATE */
);




/******************************************************************************/
/****                             Primary keys                             ****/
/******************************************************************************/

ALTER TABLE PROCESSOS_MINERAR ADD CONSTRAINT PK_PROCESSOS_MINERAR PRIMARY KEY (CODIGO);


/******************************************************************************/
/****                             Foreign keys                             ****/
/******************************************************************************/

ALTER TABLE PROCESSOS_MINERAR ADD CONSTRAINT FK_PROCESSOS_MINERAR_1 FOREIGN KEY (COD_DADOS) REFERENCES DADOS (CODIGO);
ALTER TABLE PROCESSOS_MINERAR ADD CONSTRAINT FK_PROCESSOS_MINERAR_2 FOREIGN KEY (COD_INTERCOMUNICACAO) REFERENCES INTERCOMUNICACOES (CODIGO);


/******************************************************************************/
/****                               Indices                                ****/
/******************************************************************************/

CREATE INDEX PROCESSOS_MINERAR_IDX1 ON PROCESSOS_MINERAR (PROCESSO);
CREATE INDEX PROCESSOS_MINERAR_IDX2 ON PROCESSOS_MINERAR (ID);
CREATE INDEX PROCESSOS_MINERAR_IDX3 ON PROCESSOS_MINERAR (COD_CENTRAL_MINERADORA);
CREATE INDEX PROCESSOS_MINERAR_IDX4 ON PROCESSOS_MINERAR (TIPO);
CREATE INDEX PROCESSOS_MINERAR_IDX5 ON PROCESSOS_MINERAR (STATUS);
CREATE INDEX PROCESSOS_MINERAR_IDX6 ON PROCESSOS_MINERAR (COD_PROCESSO_MINERAR_LOTE);


/******************************************************************************/
/****                               Triggers                               ****/
/******************************************************************************/



SET TERM ^ ;



/******************************************************************************/
/****                         Triggers for tables                          ****/
/******************************************************************************/



/* Trigger: PROCESSOS_MINERAR_BI */
CREATE OR ALTER TRIGGER PROCESSOS_MINERAR_BI FOR PROCESSOS_MINERAR
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  IF (NEW.CODIGO IS NULL) THEN
    NEW.CODIGO = GEN_ID(GEN_PROCESSOS_MINERAR_ID,1);
END
^


/* Trigger: PROCESSOS_MINERAR_DATA_INC */
CREATE OR ALTER TRIGGER PROCESSOS_MINERAR_DATA_INC FOR PROCESSOS_MINERAR
ACTIVE BEFORE INSERT POSITION 2
AS
BEGIN
  NEW.DATA_INC = CURRENT_TIMESTAMP;
END
^


/* Trigger: PROCESSOS_MINERAR_USUARIO */
CREATE OR ALTER TRIGGER PROCESSOS_MINERAR_USUARIO FOR PROCESSOS_MINERAR
ACTIVE BEFORE INSERT POSITION 1
AS
DECLARE VARIABLE I_TEMP INTEGER;
BEGIN
    SELECT COD_USUARIO 
    FROM FUNCAO_COD_USUARIO 
    INTO :I_TEMP;

    NEW.COD_USUARIO = :I_TEMP;
END
^

SET TERM ; ^



/******************************************************************************/
/****                         Fields descriptions                          ****/
/******************************************************************************/

COMMENT ON COLUMN PROCESSOS_MINERAR.STATUS IS 
'NULL ou 0 = Não enviado
1 = Enviado para API
2 = Atualizado
3 = Erro
4 = Reenviar novamente';