ALTER TABLE CONTROLE_CALCULO
ADD DATA_FIM DOM_DATA_HORA;

SET TERM ^ ;



CREATE OR ALTER TRIGGER CONTROLE_CALCULO_INT_CIT_NOT FOR CONTROLE_CALCULO
ACTIVE AFTER INSERT POSITION 2
as
declare variable I_TEMP DOM_CODIGO;
declare variable CODIGO_INTIMACAO DOM_CODIGO;
declare variable COD_DADOS DOM_CODIGO;
declare variable JAH_EXISTE DOM_CODIGO;
declare variable QTDE_INTIMACOES DOM_CODIGO;
declare variable QTDE_PJE_INTIMACOES DOM_CODIGO;
declare variable QTDE_INTIMACOES_WORKFLOW_PROC DOM_CODIGO;
declare variable TAREFA DOM_TEXTO_050;
declare variable ATIVO DOM_CHAR_001;
declare variable ID_PROCESSAMENTO DOM_TEXTO_015;
declare variable NOME_TAREFA DOM_TEXTO_050;
declare variable SQL_TRIGGER DOM_TEXTO_100;
declare variable UF varchar(2);
begin

  /* BUSCA O CNPJ DO USUARIO */
  select first 1 USUARIO.UF
  from USUARIO
  into :UF;

  if (:UF = 'SP') then
  begin ------ se não for ROLÂNDIA PR
    execute procedure PRO_FERIADOS_SUSPENSAO_PRAZO_SP(extract(year from current_timestamp));
  end
  else
  if (:UF = 'PR') then
  begin ------ se  ROLÂNDIA PR
    execute procedure PRO_FERIADOS_SUSPENSAO_PRAZO_PR(extract(year from current_timestamp));
  end

  -------------- limpa tabela distribuição procuradores
  delete from PROCURADORES_DISTR_TEMP;
  delete from PROCURADORES_CODIGO;
  ------------- requisitorios
  execute procedure PRO_REQUISITORIOS_CALCULO_PRAZO;
  execute procedure PRO_REQUISITORIOS;

  ------gera graficos
  execute procedure PRO_GERA_GRAFICOS;
  -------------------------- Calcula prazos saj
  execute procedure PRO_INTIMACAO_CALCULA_PRAZOS;
  execute procedure PRO_INTIMACOES('R')
      returning_values :ID_PROCESSAMENTO, :NOME_TAREFA;
  execute procedure PRO_CITACAO_CALCULA_PRAZOS;
  execute procedure PRO_CITACOES_ELETRONICAS('R')
      returning_values :ID_PROCESSAMENTO, :NOME_TAREFA;

  ----atualiza data final SAJ
 -- execute procedure PRO_CAL_DATA_FINAL_INT_CITA_SAJ;
  -------- FINAL
  ---------------- Calcula prazos PJE
  execute procedure PRO_PJE_INT_CALCULA_PRAZOS;
  execute procedure PRO_PJE_INTIMACOES('R')
      returning_values :ID_PROCESSAMENTO, :NOME_TAREFA;
  execute procedure PRO_PJE_CIT_CALCULA_PRAZOS;
  execute procedure PRO_PJE_CITACOES('R')
      returning_values :ID_PROCESSAMENTO, :NOME_TAREFA;
  execute procedure PRO_PJE_NOT_CALCULA_PRAZOS;
  execute procedure PRO_PJE_NOTIFICACAO('R')
      returning_values :ID_PROCESSAMENTO, :NOME_TAREFA;

  --------------BAIXA COMPROMISSOS
  --  Tarefa 19312803 - #30557 AGENDA - Regra para agenda de compromissos
  execute procedure PRO_BAIXA_COMPROMISSOS;

  --------------- verifica se terminou ferias/afastamento dos procuradores
  execute procedure PRO_TERMINOFERIAS_PROCURADOR;

  --------------rodar pro_publicações
  execute procedure PRO_PUBLICACOES_CALCULA_PRAZOS;
  execute procedure PRO_PUBLICACOES;
  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
  select count(ID_PROCESSAMENTO), ATIVO, TAREFA
  from TAREFAS
  where ID_PROCESSAMENTO = '010.010.000.000'
  group by ATIVO, TAREFA
  into :I_TEMP, :ATIVO, :TAREFA;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('010.010.000.000', 'CDAs Não Ajuizadas', 'CDAs importadas mais não ajuizadas', 'frmRelCDAs', 'S', null);
  end

  if ((:TAREFA <> 'CDAs Não Ajuizadas') or ((:ATIVO = 'N') or (:ATIVO is null))) then
  begin
    update TAREFAS
    set TAREFAS.TAREFA = 'CDAs Não Ajuizadas',
        TAREFAS.ATIVO = 'S',
        TAREFAS.FORMULARIO = 'frmRelCDAs'
    where TAREFAS.ID_PROCESSAMENTO = '010.010.000.000';
  end

  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA execução fiscal
  I_TEMP = null;
  ATIVO = null;
  TAREFA = null;
  select count(ID_PROCESSAMENTO), ATIVO, TAREFA
  from TAREFAS
  where ID_PROCESSAMENTO = '090.040.000.000'
  group by ATIVO, TAREFA
  into :I_TEMP, :ATIVO, :TAREFA;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('090.040.000.000', 'INTIMAÇÕES PENDENTES', 'INTIMAÇÕES PENDENTES', 'frmIntimacaoPendencias', 'S', null);
  end

  if (:TAREFA <> 'INTIMAÇÕES PENDENTES') then
  begin
    update TAREFAS
    set TAREFAS.TAREFA = 'INTIMAÇÕES PENDENTES',
        TAREFAS.DESCRICAO = 'INTIMAÇÕES PENDENTES'
    where TAREFAS.ID_PROCESSAMENTO = '090.040.000.000';
  end

  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA contencioso
  I_TEMP = null;
  ATIVO = null;
  TAREFA = null;
  select count(ID_PROCESSAMENTO), ATIVO, TAREFA
  from TAREFAS
  where ID_PROCESSAMENTO = '290.040.000.000'
  group by ATIVO, TAREFA
  into :I_TEMP, :ATIVO, :TAREFA;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('290.040.000.000', 'INTIMAÇÕES PENDENTES', 'INTIMAÇÕES PENDENTES', 'frmIntimacaoPendencias', 'S', null);
  end

  if (:TAREFA <> 'INTIMAÇÕES PENDENTES') then
  begin
    update TAREFAS
    set TAREFAS.TAREFA = 'INTIMAÇÕES PENDENTES',
        TAREFAS.DESCRICAO = 'INTIMAÇÕES PENDENTES'
    where TAREFAS.ID_PROCESSAMENTO = '290.040.000.000';
  end

  -------------------------- intimação
  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '090.000.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('090.000.000.000', 'Intimações SAJ', 'Intimações SAJ', null, 'S', null);
  end
  ------------------- contencioso SAJ
  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '290.000.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('290.000.000.000', 'Intimações SAJ', 'Intimações SAJ', null, 'S', null);
  end

  JAH_EXISTE = null;
  select first 1 WORKFLOW_PROC.CODIGO
  from WORKFLOW
  inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
        --  left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
  where WORKFLOW.COD_TAREFA = '290.000.000.000' and
        WORKFLOW_PROC.DATA_BAIXA is null
  into :JAH_EXISTE;

  if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
  begin
    execute procedure PRO_WORKFLOW('I', null, null, null, null, '290.000.000.000', 'INTIMACOES', null, null);
  end

  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '090.005.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('090.005.000.000', 'Lista para Ciência obtida em: ', 'Lista para Ciência obtida em: ',
            'frmIntimacaoSolicitarListaAgCiencia', 'S', null);
  end

  JAH_EXISTE = null;
  select first 1 WORKFLOW_PROC.CODIGO
  from WORKFLOW
  inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
        --  left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
  where WORKFLOW.COD_TAREFA = '090.005.000.000' and
        WORKFLOW_PROC.DATA_BAIXA is null
  into :JAH_EXISTE;

  if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
  begin
    execute procedure PRO_WORKFLOW('I', null, null, null, null, '090.005.000.000', 'INTIMACOES', null, null);
  end

  ------------------- contencioso SAJ
  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '290.005.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('290.005.000.000', 'Lista para Ciência obtida em: ', 'Lista para Ciência obtida em: ',
            'frmIntimacaoSolicitarListaAgCiencia', 'S', null);
  end

  JAH_EXISTE = null;
  select first 1 WORKFLOW_PROC.CODIGO
  from WORKFLOW
  inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
  left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
  where WORKFLOW.COD_TAREFA = '290.005.000.000' and
        WORKFLOW_PROC.DATA_BAIXA is null
  into :JAH_EXISTE;

  if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
  begin
    execute procedure PRO_WORKFLOW('I', null, null, null, null, '290.005.000.000', 'INTIMACOES', null, null);
  end

  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '090.007.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('090.007.000.000 ', 'Obter Lista c/ Prazo Iniciado', 'Obter Lista c/ Prazo Iniciado',
            'frmIntimacaoSolicitarListaAutoConfirmada', 'S', null);
  end

  JAH_EXISTE = null;
  select first 1 WORKFLOW_PROC.CODIGO
  from WORKFLOW
  inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
  left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
  where WORKFLOW.COD_TAREFA = '090.007.000.000' and
        WORKFLOW_PROC.DATA_BAIXA is null
  into :JAH_EXISTE;

  if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
  begin
    execute procedure PRO_WORKFLOW('I', null, null, null, null, '090.007.000.000', 'INTIMACOES', null, null);
  end

  ------------------- contencioso SAJ
  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '290.007.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('290.007.000.000 ', 'Obter Lista c/ Prazo Iniciado', 'Obter Lista c/ Prazo Iniciado',
            'frmIntimacaoSolicitarListaAutoConfirmada', 'S', null);
  end

  JAH_EXISTE = null;
  select first 1 WORKFLOW_PROC.CODIGO
  from WORKFLOW
  inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
  left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
  where WORKFLOW.COD_TAREFA = '290.007.000.000' and
        WORKFLOW_PROC.DATA_BAIXA is null
  into :JAH_EXISTE;

  if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
  begin
    execute procedure PRO_WORKFLOW('I', null, null, null, null, '290.007.000.000', 'INTIMACOES', null, null);
  end

  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '090.020.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('090.020.000.000', 'Obter Intimações c/ Prazo Iniciado', 'Obter Intimações c/ Prazo Iniciado',
            'frmIntimacaoSolicitarAutoConfirmada', 'S', null);
  end

  JAH_EXISTE = null;
  select first 1 WORKFLOW_PROC.CODIGO
  from WORKFLOW
  inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
  left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
  where WORKFLOW.COD_TAREFA = '090.020.000.000' and
        WORKFLOW_PROC.DATA_BAIXA is null
  into :JAH_EXISTE;

  if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
  begin
    execute procedure PRO_WORKFLOW('I', null, null, null, null, '090.020.000.000', 'INTIMACOES', null, null);
  end

  ------------------- contencioso SAJ
  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '290.020.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('290.020.000.000', 'Obter Intimações c/ Prazo Iniciado', 'Obter Intimações c/ Prazo Iniciado',
            'frmIntimacaoSolicitarAutoConfirmada', 'S', null);
  end

  JAH_EXISTE = null;
  select first 1 WORKFLOW_PROC.CODIGO
  from WORKFLOW
  inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
  left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
  where WORKFLOW.COD_TAREFA = '290.020.000.000' and
        WORKFLOW_PROC.DATA_BAIXA is null
  into :JAH_EXISTE;

  if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
  begin
    execute procedure PRO_WORKFLOW('I', null, null, null, null, '290.020.000.000', 'INTIMACOES', null, null);
  end

  --------------------------------------------------------------------------- INTIMACOES PJE
  /* select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '091.000.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('091.000.000.000', 'Avisos Pendentes', 'Avisos Pendentes', null, 'S', null);
    end

    JAH_EXISTE = null;
    select first 1 WORKFLOW_PROC.CODIGO
    from WORKFLOW
    inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
    left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
    where WORKFLOW.COD_TAREFA = '091.000.000.000' and
          WORKFLOW_PROC.DATA_BAIXA is null
    into :JAH_EXISTE;

    if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
    begin
      execute procedure PRO_WORKFLOW('I', null, null, null, null, '091.000.000.000', 'PJE_INTIMACOES', null, null);
    end   */

  ------------------- pje avisos pendentes
  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
  /*   select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '091.000.000.000'
    into :I_TEMP;

    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      update TAREFAS
      set TAREFAS.ID_PROCESSAMENTO = '291.000.000.000'
      where TAREFAS.ID_PROCESSAMENTO = '091.000.000.000';
    end  */

  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
  /*  select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '291.000.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('291.000.000.000', 'Avisos Pendentes', 'Avisos Pendentes', null, 'S', null);
    end  */
  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '093.000.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('093.000.000.000', 'Intimações PJe', 'Intimações PJe', null, 'S', null);
    execute procedure PRO_PERMISSAO_GRUPO_TAREFA('093.000.000.000',
        'Administrador, Manutenção, Procurador, Procuradores');
  end

  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '293.000.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('293.000.000.000', 'Intimações PJe', 'Intimações PJe', null, 'S', null);
    execute procedure PRO_PERMISSAO_GRUPO_TAREFA('293.000.000.000',
        'Administrador, Manutenção, Procurador, Procuradores');
  end

  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '093.005.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('093.005.000.000', 'Lista para Ciência obtida em: ', 'Lista para Ciência obtida em: ',
            'frmPJeAvisosPendentes', 'S', null);
    execute procedure PRO_PERMISSAO_GRUPO_TAREFA('093.005.000.000',
        'Administrador, Manutenção, Procurador, Procuradores');
  end

  JAH_EXISTE = null;
  select first 1 WORKFLOW_PROC.CODIGO
  from WORKFLOW
  inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
  left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
  where WORKFLOW.COD_TAREFA = '093.005.000.000' and
        WORKFLOW_PROC.DATA_BAIXA is null
  into :JAH_EXISTE;

  if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
  begin
    execute procedure PRO_WORKFLOW('I', null, null, null, null, '093.005.000.000', 'PJE_INTIMACOES', null, null);
  end

  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '293.005.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('293.005.000.000', 'Lista para Ciência obtida em: ', 'Lista para Ciência obtida em: ',
            'frmPJeAvisosPendentes', 'S', null);
    execute procedure PRO_PERMISSAO_GRUPO_TAREFA('293.005.000.000',
        'Administrador, Manutenção, Procurador, Procuradores');
  end

  -------------------------- citação
  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '095.000.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('095.000.000.000', 'Citações Eletrônicas', 'Citações Eletrônicas', null, 'S', null);
  end
  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '095.005.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('095.005.000.000', 'Lista para Ciência obtida em: ', 'Lista para Ciência obtida em: ',
            'frmCitacaoSolicitarListaAgCiencia', 'S', null);
  end

  JAH_EXISTE = null;
  select first 1 WORKFLOW_PROC.CODIGO
  from WORKFLOW
  inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
  left outer join CITACOES_ELETRONICAS on (WORKFLOW_PROC.CHAVE_PRIMARIA = CITACOES_ELETRONICAS.CODIGO)
  where WORKFLOW.COD_TAREFA = '095.005.000.000' and
        WORKFLOW_PROC.DATA_BAIXA is null
  into :JAH_EXISTE;

  if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
  begin
    execute procedure PRO_WORKFLOW('I', null, null, null, null, '095.005.000.000', 'CITACOES_ELETRONICAS', null, null);
  end

  ---------------contencioso citação saj
  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '295.000.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('295.000.000.000', 'Lista para Ciência obtida em: ', 'Lista para Ciência obtida em: ', null, 'S', null);
  end
  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '295.005.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('295.005.000.000', 'Obter Lista p/ Ciência', 'Obter Lista p/ Ciência', 'frmCitacaoSolicitarListaAgCiencia',
            'S', null);
  end

  JAH_EXISTE = null;
  select first 1 WORKFLOW_PROC.CODIGO
  from WORKFLOW
  inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
  left outer join CITACOES_ELETRONICAS on (WORKFLOW_PROC.CHAVE_PRIMARIA = CITACOES_ELETRONICAS.CODIGO)
  where WORKFLOW.COD_TAREFA = '295.005.000.000' and
        WORKFLOW_PROC.DATA_BAIXA is null
  into :JAH_EXISTE;

  if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
  begin
    execute procedure PRO_WORKFLOW('I', null, null, null, null, '295.005.000.000', 'CITACOES_ELETRONICAS', null, null);
  end
  ---------------aqui

  -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
  select count(ID_PROCESSAMENTO)
  from TAREFAS
  where ID_PROCESSAMENTO = '095.020.000.000'
  into :I_TEMP;

  --VERIFICA  SE EXISTE ESSA TAREFA
  if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
  begin
    insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
    values ('095.020.000.000', 'Obter Citações c/ Prazo Iniciado', 'Obter Citações c/ Prazo Iniciado',
            'frmCitacaoSolicitarAutoConfirmada', 'S', null);
  end

  JAH_EXISTE = null;
  select first 1 WORKFLOW_PROC.CODIGO
  from WORKFLOW
  inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
  left outer join CITACOES_ELETRONICAS on (WORKFLOW_PROC.CHAVE_PRIMARIA = CITACOES_ELETRONICAS.CODIGO)
  where WORKFLOW.COD_TAREFA = '095.020.000.000' and
        WORKFLOW_PROC.DATA_BAIXA is null
  into :JAH_EXISTE;

  if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
  begin
    execute procedure PRO_WORKFLOW('I', null, null, null, null, '095.020.000.000', 'CITACOES_ELETRONICAS', null, null);
  end
end
^
SET TERM ; ^


/* Privileges of triggers */
GRANT SELECT, UPDATE, REFERENCES ON CONTROLE_CALCULO TO TRIGGER CONTROLE_CALCULO_INT_CIT_NOT;



/******************************************************************************/
/****              Generated by IBExpert 23/11/2023 10:08:16               ****/
/******************************************************************************/

/******************************************************************************/
/****     Following SET SQL DIALECT is just for the Database Comparer      ****/
/******************************************************************************/


/******************************************************************************/
/****                                Tables                                ****/
/******************************************************************************/


CREATE GENERATOR GEN_CONTROLE_CALCULO_PARAME_ID;

CREATE TABLE CONTROLE_CALCULO_PARAMETROS (
    CODIGO             DOM_CODIGO NOT NULL /* DOM_CODIGO = INTEGER */,
    HORARIOS_EXECUCAO  DOM_TEXTO_100 /* DOM_TEXTO_100 = VARCHAR(100) */,
    COD_USUARIO        DOM_CODIGO /* DOM_CODIGO = INTEGER */,
    DATA_INC           DOM_DATA_HORA /* DOM_DATA_HORA = DATE */
);



/******************************************************************************/
/****                             Primary keys                             ****/
/******************************************************************************/

ALTER TABLE CONTROLE_CALCULO_PARAMETROS ADD CONSTRAINT PK_CONTROLE_CALCULO_PARAMETROS PRIMARY KEY (CODIGO);


/******************************************************************************/
/****                               Triggers                               ****/
/******************************************************************************/



SET TERM ^ ;



/******************************************************************************/
/****                         Triggers for tables                          ****/
/******************************************************************************/



/* Trigger: CONTROLE_CALCULO_PARA_CODIGO */
CREATE OR ALTER TRIGGER CONTROLE_CALCULO_PARA_CODIGO FOR CONTROLE_CALCULO_PARAMETROS
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  IF (NEW.CODIGO IS NULL) THEN
    NEW.CODIGO = GEN_ID(GEN_CONTROLE_CALCULO_PARAME_ID,1);
END
^

/* Trigger: CONTROLE_CALCULO_PARA_DATA_INC */
CREATE OR ALTER TRIGGER CONTROLE_CALCULO_PARA_DATA_INC FOR CONTROLE_CALCULO_PARAMETROS
ACTIVE BEFORE INSERT POSITION 2
AS
BEGIN
  NEW.DATA_INC = CURRENT_TIMESTAMP;
END
^

/* Trigger: CONTROLE_CALCULO_PARA_USUARIO */
CREATE OR ALTER TRIGGER CONTROLE_CALCULO_PARA_USUARIO FOR CONTROLE_CALCULO_PARAMETROS
ACTIVE BEFORE INSERT POSITION 1
AS
DECLARE VARIABLE I_TEMP INTEGER;
BEGIN
  SELECT COD_USUARIO
  FROM FUNCAO_COD_USUARIO
  INTO :I_TEMP;
  NEW.COD_USUARIO = :I_TEMP;
END
^
SET TERM ; ^

SET TERM ^ ;



CREATE OR ALTER TRIGGER INTIMACOES_CITACOES_PRAZOS_CONN
ACTIVE ON CONNECT POSITION 0
as
 /*$$IBE$$ declare variable DATA_ATUALIZADA varchar(10);
declare variable DATA_ATUAL varchar(10);
declare variable DATA_INICIAL date;
declare variable DATA_FINAL date;
declare variable CODCIDADE varchar(4);
declare variable COD_RECESSO_PERIODO integer;
declare variable EXERCICIO integer;
declare variable NRO_CONTROLE integer;
declare variable UF varchar(2); $$IBE$$*/ 
begin
  /* BUSCA O CNPJ DO USUARIO */ /*$$IBE$$ 
  select first 1 USUARIO.UF
  from USUARIO
  into :UF;

  select lpad(extract(day from PARAMETROS.DATA_ATUALIZADA), 2, '0') || '/' || lpad(extract(month from PARAMETROS.DATA_ATUALIZADA), 2, '0') || '/' || extract(year from PARAMETROS.DATA_ATUALIZADA) as DATA_ATUALIZADA,
         lpad(extract(day from current_timestamp), 2, '0') || '/' || lpad(extract(month from current_timestamp), 2, '0') || '/' || extract(year from current_timestamp) as DATA_ATUAL
  from PARAMETROS
  into :DATA_ATUALIZADA, :DATA_ATUAL;

  if ((:DATA_ATUALIZADA <> :DATA_ATUAL) or (:DATA_ATUALIZADA is null)) then
  begin

    if (:UF = 'SP') then
    begin ------ se não for ROLÂNDIA PR
      execute procedure PRO_FERIADOS_SUSPENSAO_PRAZO_SP(extract(year from current_timestamp));
      ------------ Recesso forense
       $$IBE$$*/ /*   EXERCICIO = 0;
    EXERCICIO = extract(year from current_timestamp);
    DATA_INICIAL = extract(year from current_timestamp) || '/' || '12/20';
    DATA_FINAL = extract(year from current_timestamp) || '/' || '01/20';
    DATA_FINAL = dateadd(1 year to :DATA_FINAL);
    COD_RECESSO_PERIODO = 0;

    for select FORUM.CODCIDADE
        from FORUM
        where FORUM.ATIVO = 'S'
        group by FORUM.CODCIDADE
        into :CODCIDADE
    do
    begin

      COD_RECESSO_PERIODO = 0;

      if (:CODCIDADE is not null) then
        select first 1 RECESSOS.CODIGO
        from RECESSOS
        inner join RECESSOS_PERIODO on (RECESSOS.CODIGO = RECESSOS_PERIODO.COD_RECESSO)
        where RECESSOS_PERIODO.DATA_INICIO = :DATA_INICIAL and
              RECESSOS_PERIODO.DATA_FIM = :DATA_FINAL and
              RECESSOS.COD_FORO = :CODCIDADE
        into :COD_RECESSO_PERIODO;
      else
        select first 1 RECESSOS.CODIGO
        from RECESSOS
        inner join RECESSOS_PERIODO on (RECESSOS.CODIGO = RECESSOS_PERIODO.COD_RECESSO)
        where RECESSOS_PERIODO.DATA_INICIO = :DATA_INICIAL and
              RECESSOS_PERIODO.DATA_FIM = :DATA_FINAL and
              RECESSOS.COD_FORO is null
        into :COD_RECESSO_PERIODO;

      if (:COD_RECESSO_PERIODO = 0) then
      begin
        insert into RECESSOS (EXERCICIO, COD_FORO, PROVIMENTO, ARTIGO)
        values (:EXERCICIO, :CODCIDADE, 'Calendário ' || :EXERCICIO,
                'Período de recesso forense, suspensão de prazo e feriados.');

        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), :DATA_INICIAL, :DATA_FINAL, 'Recesso Forense');
        EXERCICIO = EXERCICIO;

        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-01-01 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-01-01 00:00:00', 0, 'Confraternização universal');
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-02-20 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-02-20 00:00:00', 0, 'Carnaval'); -- segunda de carnaval
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-02-21 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-02-21 00:00:00', 0, 'Carnaval'); -- terça de carnaval
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-04-06 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-04-06 00:00:00', 0, 'Endoenças');
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-04-07 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-04-07 00:00:00', 0, 'Sexta-feira Santa');
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-04-21 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-04-21 00:00:00', 0, 'Tiradentes');
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-05-01 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-05-01 00:00:00', 0, 'Dia Mundial do Trabalho');
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-06-08 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-06-08 00:00:00', 0, 'Corpus Christi');
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-06-09 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-06-09 00:00:00', 0, 'Suspensão do Expediente');
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-09-07 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-09-07 00:00:00', 0, 'Independência do Brasil');
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-09-08 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-09-08 00:00:00', 0, 'Suspensão do Expediente');
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-10-12 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-10-12 00:00:00', 0, 'Nossa Senhora Aparecida');
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-10-13 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-10-13 00:00:00', 0, 'Suspensão do Expediente');
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-11-02 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-11-02 00:00:00', 0, 'Finados');
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-11-03 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-11-03 00:00:00', 0, 'Suspensão do Expediente');
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-11-15 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-11-15 00:00:00', 0, 'Proclamação da República');
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-12-08 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-12-08 00:00:00', 0, 'Dia da Justiça');
        insert into RECESSOS_PERIODO (COD_RECESSO, DATA_INICIO, DATA_FIM, DIAS, DESCRICAO)
        values ((select max(CODIGO)
                 from RECESSOS), cast(:EXERCICIO as varchar(4)) || '-12-25 00:00:00',
                cast(:EXERCICIO as varchar(4)) || '-12-25 00:00:00', 0, 'Natal');
      end
    end  */ /*$$IBE$$ 
      --------------------------
    end
    else
    if (:UF = 'PR') then
    begin ------ se  ROLÂNDIA PR
      execute procedure PRO_FERIADOS_SUSPENSAO_PRAZO_PR(extract(year from current_timestamp));
    end

     $$IBE$$*/ /* if ((:DATA_ATUALIZADA <> :DATA_ATUAL) or (:DATA_ATUALIZADA is null)) then
  begin */ /*$$IBE$$ 
    update PARAMETROS
    set PARAMETROS.DATA_ATUALIZADA = current_timestamp;
  end

   $$IBE$$*/ /* DATA_ATUAL = lpad(extract(day from current_timestamp), 2, '0') || '/' || lpad(extract(month from current_timestamp), 2, '0') || '/' || extract(year from current_timestamp);
  select CONTROLE_CALCULO.NRO_CONTROLE
  from CONTROLE_CALCULO
  where lpad(extract(day from CONTROLE_CALCULO.DATA_INC), 2, '0') || '/'
  || lpad(extract(month from CONTROLE_CALCULO.DATA_INC), 2, '0') || '/'
  || extract(year from CONTROLE_CALCULO.DATA_INC) >= :DATA_ATUAL
  into :NRO_CONTROLE;

  if ((:NRO_CONTROLE = 0) or (:NRO_CONTROLE is null)) then
  begin
    insert into CONTROLE_CALCULO (NRO_CONTROLE)
    values (1);
  end  */
POST_EVENT '$$IBE$$';
end
^
SET TERM ; ^


SET TERM ^ ;



CREATE OR ALTER TRIGGER PARAMETROS_TAREFA_INTI_CITA FOR PARAMETROS
ACTIVE AFTER UPDATE POSITION 2
as
 /*$$IBE$$ declare variable I_TEMP DOM_CODIGO;
declare variable CODIGO_INTIMACAO DOM_CODIGO;
declare variable COD_DADOS DOM_CODIGO;
declare variable JAH_EXISTE DOM_CODIGO;
declare variable QTDE_INTIMACOES DOM_CODIGO;
declare variable QTDE_PJE_INTIMACOES DOM_CODIGO;
declare variable QTDE_INTIMACOES_WORKFLOW_PROC DOM_CODIGO;
declare variable TAREFA DOM_TEXTO_050;
declare variable ATIVO DOM_CHAR_001;
declare variable ID_PROCESSAMENTO DOM_TEXTO_015;
declare variable NOME_TAREFA DOM_TEXTO_050;
declare variable COD_PARAMETRO_DO_LOG DOM_CODIGO;
declare variable EXERCICIO_BANCO DOM_CODIGO;
declare variable EXERCICIO_ATUAL DOM_CODIGO;
declare variable CAMINHO_COMPLETO DOM_TEXTO_200; $$IBE$$*/ 
begin /*$$IBE$$ 

  if (new.DATA_ATUALIZADA is distinct from old.DATA_ATUALIZADA) then
  begin
    ---------------- renomeia banco de log para novo exercicio
     $$IBE$$*/ /*   EXERCICIO_ATUAL = 0;
    EXERCICIO_ATUAL = extract(year from current_timestamp);

    COD_PARAMETRO_DO_LOG = 0;
    select first 1 PARAMETROS_DO_LOG.COD_PARAMETRO_DO_LOG, PARAMETROS_DO_LOG.EXERCICIO_BANCO
    from PARAMETROS_DO_LOG
    where PARAMETROS_DO_LOG.NOME_BANCO like '%LOG%' and
          PARAMETROS_DO_LOG.LOG_EXTERNO = 1
    into :COD_PARAMETRO_DO_LOG, :EXERCICIO_BANCO;

    select substring(PARAMETROS_DO_LOG.CAMINHO_BANCO from 1 for (position(':', PARAMETROS_DO_LOG.CAMINHO_BANCO) - 1)) || ':' || substring(PARAMETROS_DO_LOG.CAMINHO_BANCO from position(':', PARAMETROS_DO_LOG.CAMINHO_BANCO) + 1 for (position('INTERLITIS_LOG', PARAMETROS_DO_LOG.CAMINHO_BANCO) - 1) - (position(':', PARAMETROS_DO_LOG.CAMINHO_BANCO))) || 'INTERLITIS_LOG_' ||(select extract(year from current_timestamp)
                                                                                                                                                                                                                                                                                                                                                                                    from RDB$DATABASE) || '.FDB' CAMINHO_COMPLETO
    from PARAMETROS_DO_LOG
    where PARAMETROS_DO_LOG.COD_PARAMETRO_DO_LOG = :COD_PARAMETRO_DO_LOG
    into :CAMINHO_COMPLETO;

    if (:EXERCICIO_ATUAL <> :EXERCICIO_BANCO) then
    begin
      update PARAMETROS_DO_LOG
      set PARAMETROS_DO_LOG.CAMINHO_BANCO = :CAMINHO_COMPLETO,
          PARAMETROS_DO_LOG.EXERCICIO_BANCO = :EXERCICIO_ATUAL
      where PARAMETROS_DO_LOG.COD_PARAMETRO_DO_LOG = :COD_PARAMETRO_DO_LOG;
    end */ /*$$IBE$$ 
    -------------- limpa tabela distribuição procuradores
    delete from PROCURADORES_DISTR_TEMP;
    delete from PROCURADORES_CODIGO;
    ------------- requisitorios
    execute procedure PRO_REQUISITORIOS_CALCULO_PRAZO;
    execute procedure PRO_REQUISITORIOS;

    ------gera graficos
    execute procedure PRO_GERA_GRAFICOS;
    -------------------------- Calcula prazos saj
    execute procedure PRO_INTIMACAO_CALCULA_PRAZOS;
    execute procedure PRO_INTIMACOES('R')
        returning_values :ID_PROCESSAMENTO, :NOME_TAREFA;
    execute procedure PRO_CITACAO_CALCULA_PRAZOS;
    execute procedure PRO_CITACOES_ELETRONICAS('R')
        returning_values :ID_PROCESSAMENTO, :NOME_TAREFA;

    ----atualiza data final SAJ
    execute procedure PRO_CAL_DATA_FINAL_INT_CITA_SAJ;
    -------- FINAL
    ---------------- Calcula prazos PJE
    execute procedure PRO_PJE_INT_CALCULA_PRAZOS;
    execute procedure PRO_PJE_INTIMACOES('R')
        returning_values :ID_PROCESSAMENTO, :NOME_TAREFA;
    execute procedure PRO_PJE_CIT_CALCULA_PRAZOS;
    execute procedure PRO_PJE_CITACOES('R')
        returning_values :ID_PROCESSAMENTO, :NOME_TAREFA;
    execute procedure PRO_PJE_NOT_CALCULA_PRAZOS;
    execute procedure PRO_PJE_NOTIFICACAO('R')
        returning_values :ID_PROCESSAMENTO, :NOME_TAREFA;

    --------------BAIXA COMPROMISSOS
    --  Tarefa 19312803 - #30557 AGENDA - Regra para agenda de compromissos
    execute procedure PRO_BAIXA_COMPROMISSOS;

    --------------- verifica se terminou ferias/afastamento dos procuradores
    execute procedure PRO_TERMINOFERIAS_PROCURADOR;

    --------------rodar pro_publicações
    execute procedure PRO_PUBLICACOES_CALCULA_PRAZOS;
    execute procedure PRO_PUBLICACOES;

    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
    select count(ID_PROCESSAMENTO), ATIVO, TAREFA
    from TAREFAS
    where ID_PROCESSAMENTO = '010.010.000.000'
    group by ATIVO, TAREFA
    into :I_TEMP, :ATIVO, :TAREFA;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('010.010.000.000', 'CDAs Não Ajuizadas', 'CDAs importadas mais não ajuizadas', 'frmRelCDAs', 'S', null);
    end

    if ((:TAREFA <> 'CDAs Não Ajuizadas') or ((:ATIVO = 'N') or (:ATIVO is null))) then
    begin
      update TAREFAS
      set TAREFAS.TAREFA = 'CDAs Não Ajuizadas',
          TAREFAS.ATIVO = 'S',
          TAREFAS.FORMULARIO = 'frmRelCDAs'
      where TAREFAS.ID_PROCESSAMENTO = '010.010.000.000';
    end

    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA execução fiscal
    I_TEMP = null;
    ATIVO = null;
    TAREFA = null;
    select count(ID_PROCESSAMENTO), ATIVO, TAREFA
    from TAREFAS
    where ID_PROCESSAMENTO = '090.040.000.000'
    group by ATIVO, TAREFA
    into :I_TEMP, :ATIVO, :TAREFA;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('090.040.000.000', 'INTIMAÇÕES PENDENTES', 'INTIMAÇÕES PENDENTES', 'frmIntimacaoPendencias', 'S', null);
    end

    if (:TAREFA <> 'INTIMAÇÕES PENDENTES') then
    begin
      update TAREFAS
      set TAREFAS.TAREFA = 'INTIMAÇÕES PENDENTES',
          TAREFAS.DESCRICAO = 'INTIMAÇÕES PENDENTES'
      where TAREFAS.ID_PROCESSAMENTO = '090.040.000.000';
    end

    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA contencioso
    I_TEMP = null;
    ATIVO = null;
    TAREFA = null;
    select count(ID_PROCESSAMENTO), ATIVO, TAREFA
    from TAREFAS
    where ID_PROCESSAMENTO = '290.040.000.000'
    group by ATIVO, TAREFA
    into :I_TEMP, :ATIVO, :TAREFA;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('290.040.000.000', 'INTIMAÇÕES PENDENTES', 'INTIMAÇÕES PENDENTES', 'frmIntimacaoPendencias', 'S', null);
    end

    if (:TAREFA <> 'INTIMAÇÕES PENDENTES') then
    begin
      update TAREFAS
      set TAREFAS.TAREFA = 'INTIMAÇÕES PENDENTES',
          TAREFAS.DESCRICAO = 'INTIMAÇÕES PENDENTES'
      where TAREFAS.ID_PROCESSAMENTO = '290.040.000.000';
    end

    -------------------------- intimação
    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '090.000.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('090.000.000.000', 'Intimações SAJ', 'Intimações SAJ', null, 'S', null);
    end
    ------------------- contencioso SAJ
    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '290.000.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('290.000.000.000', 'Intimações SAJ', 'Intimações SAJ', null, 'S', null);
    end

    JAH_EXISTE = null;
    select first 1 WORKFLOW_PROC.CODIGO
    from WORKFLOW
    inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
          --  left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
    where WORKFLOW.COD_TAREFA = '290.000.000.000' and
          WORKFLOW_PROC.DATA_BAIXA is null
    into :JAH_EXISTE;

    if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
    begin
      execute procedure PRO_WORKFLOW('I', null, null, null, null, '290.000.000.000', 'INTIMACOES', null, null);
    end

    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '090.005.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('090.005.000.000', 'Lista para Ciência obtida em: ', 'Lista para Ciência obtida em: ',
              'frmIntimacaoSolicitarListaAgCiencia', 'S', null);
    end

    JAH_EXISTE = null;
    select first 1 WORKFLOW_PROC.CODIGO
    from WORKFLOW
    inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
          --  left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
    where WORKFLOW.COD_TAREFA = '090.005.000.000' and
          WORKFLOW_PROC.DATA_BAIXA is null
    into :JAH_EXISTE;

    if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
    begin
      execute procedure PRO_WORKFLOW('I', null, null, null, null, '090.005.000.000', 'INTIMACOES', null, null);
    end

    ------------------- contencioso SAJ
    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '290.005.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('290.005.000.000', 'Lista para Ciência obtida em: ', 'Lista para Ciência obtida em: ',
              'frmIntimacaoSolicitarListaAgCiencia', 'S', null);
    end

    JAH_EXISTE = null;
    select first 1 WORKFLOW_PROC.CODIGO
    from WORKFLOW
    inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
    left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
    where WORKFLOW.COD_TAREFA = '290.005.000.000' and
          WORKFLOW_PROC.DATA_BAIXA is null
    into :JAH_EXISTE;

    if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
    begin
      execute procedure PRO_WORKFLOW('I', null, null, null, null, '290.005.000.000', 'INTIMACOES', null, null);
    end

    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '090.007.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('090.007.000.000 ', 'Obter Lista c/ Prazo Iniciado', 'Obter Lista c/ Prazo Iniciado',
              'frmIntimacaoSolicitarListaAutoConfirmada', 'S', null);
    end

    JAH_EXISTE = null;
    select first 1 WORKFLOW_PROC.CODIGO
    from WORKFLOW
    inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
    left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
    where WORKFLOW.COD_TAREFA = '090.007.000.000' and
          WORKFLOW_PROC.DATA_BAIXA is null
    into :JAH_EXISTE;

    if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
    begin
      execute procedure PRO_WORKFLOW('I', null, null, null, null, '090.007.000.000', 'INTIMACOES', null, null);
    end

    ------------------- contencioso SAJ
    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '290.007.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('290.007.000.000 ', 'Obter Lista c/ Prazo Iniciado', 'Obter Lista c/ Prazo Iniciado',
              'frmIntimacaoSolicitarListaAutoConfirmada', 'S', null);
    end

    JAH_EXISTE = null;
    select first 1 WORKFLOW_PROC.CODIGO
    from WORKFLOW
    inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
    left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
    where WORKFLOW.COD_TAREFA = '290.007.000.000' and
          WORKFLOW_PROC.DATA_BAIXA is null
    into :JAH_EXISTE;

    if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
    begin
      execute procedure PRO_WORKFLOW('I', null, null, null, null, '290.007.000.000', 'INTIMACOES', null, null);
    end

    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '090.020.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('090.020.000.000', 'Obter Intimações c/ Prazo Iniciado', 'Obter Intimações c/ Prazo Iniciado',
              'frmIntimacaoSolicitarAutoConfirmada', 'S', null);
    end

    JAH_EXISTE = null;
    select first 1 WORKFLOW_PROC.CODIGO
    from WORKFLOW
    inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
    left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
    where WORKFLOW.COD_TAREFA = '090.020.000.000' and
          WORKFLOW_PROC.DATA_BAIXA is null
    into :JAH_EXISTE;

    if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
    begin
      execute procedure PRO_WORKFLOW('I', null, null, null, null, '090.020.000.000', 'INTIMACOES', null, null);
    end

    ------------------- contencioso SAJ
    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '290.020.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('290.020.000.000', 'Obter Intimações c/ Prazo Iniciado', 'Obter Intimações c/ Prazo Iniciado',
              'frmIntimacaoSolicitarAutoConfirmada', 'S', null);
    end

    JAH_EXISTE = null;
    select first 1 WORKFLOW_PROC.CODIGO
    from WORKFLOW
    inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
    left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
    where WORKFLOW.COD_TAREFA = '290.020.000.000' and
          WORKFLOW_PROC.DATA_BAIXA is null
    into :JAH_EXISTE;

    if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
    begin
      execute procedure PRO_WORKFLOW('I', null, null, null, null, '290.020.000.000', 'INTIMACOES', null, null);
    end

    --------------------------------------------------------------------------- INTIMACOES PJE
     $$IBE$$*/ /* select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '091.000.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('091.000.000.000', 'Avisos Pendentes', 'Avisos Pendentes', null, 'S', null);
    end

    JAH_EXISTE = null;
    select first 1 WORKFLOW_PROC.CODIGO
    from WORKFLOW
    inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
    left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
    where WORKFLOW.COD_TAREFA = '091.000.000.000' and
          WORKFLOW_PROC.DATA_BAIXA is null
    into :JAH_EXISTE;

    if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
    begin
      execute procedure PRO_WORKFLOW('I', null, null, null, null, '091.000.000.000', 'PJE_INTIMACOES', null, null);
    end   */ /*$$IBE$$ 

    ------------------- pje avisos pendentes
    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
     $$IBE$$*/ /*   select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '091.000.000.000'
    into :I_TEMP;

    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      update TAREFAS
      set TAREFAS.ID_PROCESSAMENTO = '291.000.000.000'
      where TAREFAS.ID_PROCESSAMENTO = '091.000.000.000';
    end  */ /*$$IBE$$ 

    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
     $$IBE$$*/ /*  select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '291.000.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('291.000.000.000', 'Avisos Pendentes', 'Avisos Pendentes', null, 'S', null);
    end  */ /*$$IBE$$ 
    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '093.000.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('093.000.000.000', 'Intimações PJe', 'Intimações PJe', null, 'S', null);
      execute procedure PRO_PERMISSAO_GRUPO_TAREFA('093.000.000.000',
          'Administrador, Manutenção, Procurador, Procuradores');
    end

    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '293.000.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('293.000.000.000', 'Intimações PJe', 'Intimações PJe', null, 'S', null);
      execute procedure PRO_PERMISSAO_GRUPO_TAREFA('293.000.000.000',
          'Administrador, Manutenção, Procurador, Procuradores');
    end

    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '093.005.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('093.005.000.000', 'Lista para Ciência obtida em: ', 'Lista para Ciência obtida em: ',
              'frmPJeAvisosPendentes', 'S', null);
      execute procedure PRO_PERMISSAO_GRUPO_TAREFA('093.005.000.000',
          'Administrador, Manutenção, Procurador, Procuradores');
    end

    JAH_EXISTE = null;
    select first 1 WORKFLOW_PROC.CODIGO
    from WORKFLOW
    inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
    left outer join INTIMACOES on (WORKFLOW_PROC.CHAVE_PRIMARIA = INTIMACOES.CODIGO)
    where WORKFLOW.COD_TAREFA = '093.005.000.000' and
          WORKFLOW_PROC.DATA_BAIXA is null
    into :JAH_EXISTE;

    if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
    begin
      execute procedure PRO_WORKFLOW('I', null, null, null, null, '093.005.000.000', 'PJE_INTIMACOES', null, null);
    end

    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '293.005.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('293.005.000.000', 'Lista para Ciência obtida em: ', 'Lista para Ciência obtida em: ',
              'frmPJeAvisosPendentes', 'S', null);
      execute procedure PRO_PERMISSAO_GRUPO_TAREFA('293.005.000.000',
          'Administrador, Manutenção, Procurador, Procuradores');
    end

    -------------------------- citação
    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '095.000.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('095.000.000.000', 'Citações Eletrônicas', 'Citações Eletrônicas', null, 'S', null);
    end
    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '095.005.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('095.005.000.000', 'Lista para Ciência obtida em: ', 'Lista para Ciência obtida em: ',
              'frmCitacaoSolicitarListaAgCiencia', 'S', null);
    end

    JAH_EXISTE = null;
    select first 1 WORKFLOW_PROC.CODIGO
    from WORKFLOW
    inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
    left outer join CITACOES_ELETRONICAS on (WORKFLOW_PROC.CHAVE_PRIMARIA = CITACOES_ELETRONICAS.CODIGO)
    where WORKFLOW.COD_TAREFA = '095.005.000.000' and
          WORKFLOW_PROC.DATA_BAIXA is null
    into :JAH_EXISTE;

    if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
    begin
      execute procedure PRO_WORKFLOW('I', null, null, null, null, '095.005.000.000', 'CITACOES_ELETRONICAS', null, null);
    end

    ---------------contencioso citação saj
    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '295.000.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('295.000.000.000', 'Lista para Ciência obtida em: ', 'Lista para Ciência obtida em: ', null, 'S', null);
    end
    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '295.005.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('295.005.000.000', 'Obter Lista p/ Ciência', 'Obter Lista p/ Ciência',
              'frmCitacaoSolicitarListaAgCiencia', 'S', null);
    end

    JAH_EXISTE = null;
    select first 1 WORKFLOW_PROC.CODIGO
    from WORKFLOW
    inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
    left outer join CITACOES_ELETRONICAS on (WORKFLOW_PROC.CHAVE_PRIMARIA = CITACOES_ELETRONICAS.CODIGO)
    where WORKFLOW.COD_TAREFA = '295.005.000.000' and
          WORKFLOW_PROC.DATA_BAIXA is null
    into :JAH_EXISTE;

    if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
    begin
      execute procedure PRO_WORKFLOW('I', null, null, null, null, '295.005.000.000', 'CITACOES_ELETRONICAS', null, null);
    end
    ---------------aqui

    -- FAZ CONSULTA PARA VERIFICAR SE EXISTE ESSA TAREFA
    select count(ID_PROCESSAMENTO)
    from TAREFAS
    where ID_PROCESSAMENTO = '095.020.000.000'
    into :I_TEMP;

    --VERIFICA  SE EXISTE ESSA TAREFA
    if ((:I_TEMP <= 0) or (:I_TEMP is null)) then
    begin
      insert into TAREFAS (ID_PROCESSAMENTO, TAREFA, DESCRICAO, FORMULARIO, ATIVO, PRAZO)
      values ('095.020.000.000', 'Obter Citações c/ Prazo Iniciado', 'Obter Citações c/ Prazo Iniciado',
              'frmCitacaoSolicitarAutoConfirmada', 'S', null);
    end

    JAH_EXISTE = null;
    select first 1 WORKFLOW_PROC.CODIGO
    from WORKFLOW
    inner join WORKFLOW_PROC on (WORKFLOW.CODIGO = WORKFLOW_PROC.COD_WORK)
    left outer join CITACOES_ELETRONICAS on (WORKFLOW_PROC.CHAVE_PRIMARIA = CITACOES_ELETRONICAS.CODIGO)
    where WORKFLOW.COD_TAREFA = '095.020.000.000' and
          WORKFLOW_PROC.DATA_BAIXA is null
    into :JAH_EXISTE;

    if ((:JAH_EXISTE = 0) or (:JAH_EXISTE is null)) then
    begin
      execute procedure PRO_WORKFLOW('I', null, null, null, null, '095.020.000.000', 'CITACOES_ELETRONICAS', null, null);
    end
  end
 $$IBE$$*/ POST_EVENT '$$IBE$$';
end
^
SET TERM ; ^


/* Privileges of triggers */
GRANT SELECT, UPDATE, REFERENCES ON PARAMETROS TO TRIGGER PARAMETROS_TAREFA_INTI_CITA;