EXECUTE BLOCK
RETURNS (
    TIPO INTEGER,
    TABELA VARCHAR(25),
    PROCESSO_CNJ VARCHAR(25),
    SEQ_RECURSO INTEGER,
    DATA_HORA DOM_DATA_HORA,
    PROC_MIN_STATUS INTEGER,
    PROC_MIN_OBS DOM_TEXTO_300)
AS

DECLARE VARIABLE INT_TIPO INTEGER;
DECLARE VARIABLE STR_TABELA VARCHAR(25);
DECLARE VARIABLE STR_PROCESSO_CNJ VARCHAR(25);
DECLARE VARIABLE INT_SEQ_RECURSO INTEGER;
DECLARE VARIABLE DTA_DATA_HORA DOM_DATA_HORA;
DECLARE VARIABLE INT_PROC_MIN_CODIGO INTEGER;
DECLARE VARIABLE INT_PROC_MIN_STATUS INTEGER;
DECLARE VARIABLE STR_PROC_MIN_OBS DOM_TEXTO_300;
DECLARE VARIABLE DTA_DATA_INTIMACAO DOM_DATA_HORA;
DECLARE VARIABLE DTA_DATA_CITACAO DOM_DATA_HORA;
DECLARE VARIABLE DTA_DATA_PUBLICACAO DOM_DATA_HORA;
DECLARE VARIABLE STR_PROCESSO_CNJ_SEQ_RECURSO VARCHAR(40);
BEGIN
  INT_TIPO = NULL;
  STR_TABELA = NULL;
  STR_PROCESSO_CNJ = NULL;
  INT_SEQ_RECURSO = NULL;
  DTA_DATA_HORA = NULL;
  DTA_DATA_INTIMACAO = DATEADD(-10 DAY TO CURRENT_TIMESTAMP);
  DTA_DATA_CITACAO = DATEADD(-3 DAY TO CURRENT_TIMESTAMP);
  DTA_DATA_PUBLICACAO = DATEADD(-3 DAY TO CURRENT_TIMESTAMP);

  FOR SELECT CAST(1 AS INTEGER) AS TIPO, "INTIMACOES" AS TABELA, INTIMACOES.PROCESSO_CNJ, INTIMACOES.SEQ_RECURSO,
             INTIMACOES.DATA_INC
      FROM INTIMACOES
      WHERE INTIMACOES.COD_DADOS IS NULL AND
            INTIMACOES.DATA_BAIXA IS NULL AND
            INTIMACOES.PROCESSO_CNJ IS NOT NULL AND
            ((CAST(LPAD(EXTRACT(DAY FROM INTIMACOES.DATA_INC), 2, "0") || "." || LPAD(EXTRACT(MONTH FROM INTIMACOES.DATA_INC), 2, "0") || "." || EXTRACT(YEAR FROM INTIMACOES.DATA_INC) AS DATE)) >= (CAST(LPAD(EXTRACT(DAY FROM :DTA_DATA_INTIMACAO), 2, "0") || "." || LPAD(EXTRACT(MONTH FROM :DTA_DATA_INTIMACAO), 2, "0") || "." || EXTRACT(YEAR FROM :DTA_DATA_INTIMACAO) AS DATE)))
      UNION
      SELECT CAST(2 AS INTEGER) AS TIPO, "CITACOES_ELETRONICAS" AS TABELA, CITACOES_ELETRONICAS.PROCESSO_CNJ,
             CITACOES_ELETRONICAS.SEQ_RECURSO, CITACOES_ELETRONICAS.DATA_INC
      FROM CITACOES_ELETRONICAS
      WHERE CITACOES_ELETRONICAS.COD_DADOS IS NULL AND
            CITACOES_ELETRONICAS.DATA_BAIXA IS NULL AND
            CITACOES_ELETRONICAS.PROCESSO_CNJ IS NOT NULL AND
            ((CAST(LPAD(EXTRACT(DAY FROM CITACOES_ELETRONICAS.DATA_INC), 2, "0") || "." || LPAD(EXTRACT(MONTH FROM CITACOES_ELETRONICAS.DATA_INC), 2, "0") || "." || EXTRACT(YEAR FROM CITACOES_ELETRONICAS.DATA_INC) AS DATE)) >= (CAST(LPAD(EXTRACT(DAY FROM :DTA_DATA_CITACAO), 2, "0") || "." || LPAD(EXTRACT(MONTH FROM :DTA_DATA_CITACAO), 2, "0") || "." || EXTRACT(YEAR FROM :DTA_DATA_CITACAO) AS DATE)))
      UNION
      SELECT CAST(3 AS INTEGER) AS TIPO, "PUBLICACOES" AS TABELA, PUBLICACOES.PROCESSO, PUBLICACOES.SEQ_RECURSO,
             PUBLICACOES.DATA_INC
      FROM PUBLICACOES
      WHERE PUBLICACOES.COD_DADOS IS NULL AND
            PUBLICACOES.DATA_BAIXA IS NULL AND
            PUBLICACOES.PROCESSO IS NOT NULL AND
            SUBSTRING(PUBLICACOES.PROCESSO FROM 17 FOR 4) = "8.26" AND
            CHARACTER_LENGTH(TRIM(PUBLICACOES.PROCESSO)) = 25 AND
            ((CAST(LPAD(EXTRACT(DAY FROM PUBLICACOES.DATA_INC), 2, "0") || "." || LPAD(EXTRACT(MONTH FROM PUBLICACOES.DATA_INC), 2, "0") || "." || EXTRACT(YEAR FROM PUBLICACOES.DATA_INC) AS DATE)) >= (CAST(LPAD(EXTRACT(DAY FROM :DTA_DATA_PUBLICACAO), 2, "0") || "." || LPAD(EXTRACT(MONTH FROM :DTA_DATA_PUBLICACAO), 2, "0") || "." || EXTRACT(YEAR FROM :DTA_DATA_PUBLICACAO) AS DATE)))
      GROUP BY 1, 2, 3, 4, 5
      INTO :INT_TIPO, :STR_TABELA, :STR_PROCESSO_CNJ, :INT_SEQ_RECURSO, :DTA_DATA_HORA
  DO
  BEGIN
    INT_PROC_MIN_CODIGO = NULL;
    INT_PROC_MIN_STATUS = NULL;
    STR_PROC_MIN_OBS = NULL;
    STR_PROCESSO_CNJ_SEQ_RECURSO = NULL;

    IF (:INT_SEQ_RECURSO >= 1) THEN
    BEGIN
      STR_PROCESSO_CNJ_SEQ_RECURSO = :STR_PROCESSO_CNJ || IIF(:INT_SEQ_RECURSO >= 1, "/" || LPAD(:INT_SEQ_RECURSO, 5, "0"), "");
    END
    ELSE
    BEGIN
      STR_PROCESSO_CNJ_SEQ_RECURSO = :STR_PROCESSO_CNJ;
    END

    IF (:STR_PROCESSO_CNJ_SEQ_RECURSO <> "") THEN
    BEGIN
      SELECT FIRST 1 PROCESSOS_MINERAR.CODIGO, PROCESSOS_MINERAR.STATUS, PROCESSOS_MINERAR.OBS
      FROM PROCESSOS_MINERAR
      WHERE PROCESSOS_MINERAR.STATUS = 3 AND
            PROCESSOS_MINERAR.PROCESSO = :STR_PROCESSO_CNJ_SEQ_RECURSO AND
            UPPER(PROCESSOS_MINERAR.TIPO) = "MINERAR" AND
			PROCESSOS_MINERAR.OBS <> "Segredo de Justiça"
      ORDER BY 1
      INTO :INT_PROC_MIN_CODIGO, :INT_PROC_MIN_STATUS, :STR_PROC_MIN_OBS;

      IF (:INT_PROC_MIN_CODIGO >= 1) THEN
      BEGIN
        UPDATE PROCESSOS_MINERAR
        SET PROCESSOS_MINERAR.STATUS = 4,
            PROCESSOS_MINERAR.OBS = "Liberado para mineração"
        WHERE PROCESSOS_MINERAR.CODIGO = :INT_PROC_MIN_CODIGO;
      END

      SELECT FIRST 1 PROCESSOS_MINERAR.CODIGO, PROCESSOS_MINERAR.STATUS, PROCESSOS_MINERAR.OBS
      FROM PROCESSOS_MINERAR
      WHERE PROCESSOS_MINERAR.STATUS = 3 AND
            PROCESSOS_MINERAR.PROCESSO = :STR_PROCESSO_CNJ_SEQ_RECURSO AND
            UPPER(PROCESSOS_MINERAR.TIPO) = "/MINERAR/NOVA" AND
			PROCESSOS_MINERAR.OBS <> "Segredo de Justiça"
      ORDER BY 1
      INTO :INT_PROC_MIN_CODIGO, :INT_PROC_MIN_STATUS, :STR_PROC_MIN_OBS;

      IF (:INT_PROC_MIN_CODIGO >= 1) THEN
      BEGIN
        UPDATE PROCESSOS_MINERAR
        SET PROCESSOS_MINERAR.STATUS = 4,
            PROCESSOS_MINERAR.OBS = "Liberado para mineração"
        WHERE PROCESSOS_MINERAR.CODIGO = :INT_PROC_MIN_CODIGO;
      END
    END

    TIPO = :INT_TIPO;
    TABELA = TRIM(:STR_TABELA);
    PROCESSO_CNJ = :STR_PROCESSO_CNJ;
    SEQ_RECURSO = :INT_SEQ_RECURSO;
    DATA_HORA = :DTA_DATA_HORA;
    PROC_MIN_STATUS = :INT_PROC_MIN_STATUS;
    PROC_MIN_OBS = :STR_PROC_MIN_OBS;
    SUSPEND;
  END
END