/* Faz um for select nos processos da PROCESSOS_MINERAR, Segredo de Justiça e anota na PUBLICACOES.SENHA_PUBLICACOES = 1 */
EXECUTE BLOCK
AS
DECLARE VARIABLE STR_PROCESSO VARCHAR(35);
DECLARE VARIABLE STR_PROCESSO_CNJ VARCHAR(25);
DECLARE VARIABLE STR_SEQ_RECURSO VARCHAR(9);
DECLARE VARIABLE INT_SEQ_RECURSO INTEGER;
BEGIN
  STR_PROCESSO = NULL;

  FOR SELECT DISTINCT PROCESSOS_MINERAR.PROCESSO
      FROM PROCESSOS_MINERAR
      WHERE PROCESSOS_MINERAR.STATUS = 3 AND
            UPPER(PROCESSOS_MINERAR.OBS) = "SEGREDO DE JUSTIÇA"
            -- AND PROCESSOS_MINERAR.PROCESSO CONTAINING '1000670-23.2023.8.26.0549'
      INTO :STR_PROCESSO
  DO
  BEGIN
    STR_PROCESSO = TRIM(:STR_PROCESSO);
    IF (:STR_PROCESSO <> '') THEN
    BEGIN
      STR_PROCESSO_CNJ = NULL;
      STR_SEQ_RECURSO = NULL;
      INT_SEQ_RECURSO = NULL;

      IF (CHAR_LENGTH(:STR_PROCESSO) = 25) THEN
      BEGIN
        STR_PROCESSO_CNJ = :STR_PROCESSO;
      END
      ELSE
      IF (CHAR_LENGTH(:STR_PROCESSO) > 25) THEN
      BEGIN
        STR_PROCESSO_CNJ = SUBSTRING(:STR_PROCESSO FROM 1 FOR 25);
        STR_SEQ_RECURSO = SUBSTRING(:STR_PROCESSO FROM 27 FOR 5);
        INT_SEQ_RECURSO = CAST(:STR_SEQ_RECURSO AS INTEGER);
      END

      IF (:STR_PROCESSO_CNJ IS NOT NULL) THEN
      BEGIN
        IF (:INT_SEQ_RECURSO IS NULL) THEN
        BEGIN
          UPDATE PUBLICACOES
          SET PUBLICACOES.SENHA_PUBLICACOES = 1
          WHERE PUBLICACOES.COD_DADOS IS NULL AND
                PUBLICACOES.DATA_BAIXA IS NULL AND
                PUBLICACOES.PROCESSO = :STR_PROCESSO_CNJ AND
                PUBLICACOES.SEQ_RECURSO IS NULL AND
                ((PUBLICACOES.SENHA_PUBLICACOES IS NULL) OR (PUBLICACOES.SENHA_PUBLICACOES = 0));
        END
        ELSE
        IF (:INT_SEQ_RECURSO > 0) THEN
        BEGIN
          UPDATE PUBLICACOES
          SET PUBLICACOES.SENHA_PUBLICACOES = 1
          WHERE PUBLICACOES.COD_DADOS IS NULL AND
                PUBLICACOES.DATA_BAIXA IS NULL AND
                PUBLICACOES.PROCESSO = :STR_PROCESSO_CNJ AND
                PUBLICACOES.SEQ_RECURSO = :INT_SEQ_RECURSO AND
                ((PUBLICACOES.SENHA_PUBLICACOES IS NULL) OR (PUBLICACOES.SENHA_PUBLICACOES = 0));

          UPDATE PUBLICACOES
          SET PUBLICACOES.SENHA_PUBLICACOES = 1
          WHERE PUBLICACOES.COD_DADOS IS NULL AND
                PUBLICACOES.DATA_BAIXA IS NULL AND
                PUBLICACOES.PROCESSO = :STR_PROCESSO AND
                ((PUBLICACOES.SENHA_PUBLICACOES IS NULL) OR (PUBLICACOES.SENHA_PUBLICACOES = 0));
        END
      END
    END
    --   SUSPEND;
  END
END